%%%%%%%%%%%%%%%%%%%%%%%
% analyzeContactList
%%%%%%%%%%%%%%%%%%%%%%%
function  [summary1, summaryMean,summaryQuartiles] = analyzeContactList(contactList, numIndivs, numContacts,sumConnect,maxConnect)
    % outputs matrix with interaction frequency of all agents with all other agents; and mean interaction number for each agent
    % is called only when test analysis turned on (bAnalysisOnly=1: limited condition, repetitions, and generations and no data recording)
	%		input:
	% 	contactList: matrix of specifying the number of interaction of each agent with each other agent
	% 	numIndivs: number of agents in this generation
	% 	numContacts: number of interaction partners 
	% 	sumConnect: number of interactions of an agent
	% 	maxConnect: maximum number of interactions with another agent
	% output:
	%		summary1:  matrix with interaction frequency of all agents with all other agents 
	%     summaryMean: mean interaction number for each agent
	%     summaryQuartiles: outputs 25% and 75% quantiles for maximum number of interactions
	
    numDyads=size(contactList,1);						% 
    summary1=zeros(numIndivs,sumConnect);
    summaryQuartiles=zeros(numIndivs,3);
    countContacts=zeros(numIndivs,1);
    lastContact=zeros(numIndivs*1000+numIndivs,1)-1;
    contactCodes=contactList(:,1)*1000+contactList(:,2);
    for ci=1:numDyads
        if contactCodes(ci,1)>0
            if (lastContact(contactCodes(ci,1))<0)
               lastContact(contactCodes(ci,1))=ci; 
            else
                countContacts(contactList(ci,1))=countContacts(contactList(ci,1))+1;
                countContacts(contactList(ci,2))=countContacts(contactList(ci,2))+1;
                count1=0;
                count2=0;
                for di=lastContact(contactCodes(ci,1)):ci
                    if ((contactList(di,1)==contactList(ci,1))||(contactList(di,2)==contactList(ci,1)))
                        count1=count1+1;
                    end
                    if ((contactList(di,1)==contactList(ci,2))||(contactList(di,2)==contactList(ci,2)))
                        count2=count2+1;
                    end
                end
                 summary1( contactList(ci,1),countContacts(contactList(ci,1))  )=count1;
                 summary1( contactList(ci,2),countContacts(contactList(ci,2))  )= count2;
               lastContact(contactCodes(ci,1))=ci; 
            end
        end
    end
    maxContacts=max(countContacts);
    summaryMean=mean(summary1(:,1:maxContacts),2);
    summaryQuartiles(:,1:3)=quantile(summary1(:,1:maxContacts),3,2);
end