%%%%%%%%%%%%%%%%%%%%%%%
% createContactListRandomOrderDistractor
%%%%%%%%%%%%%%%%%%%%%%%
function [ connectionList ] = createContactListRandomOrderDistractor( pairConnections,bDistractor,numDistractionsPerIndiv )
    % reshuffles the number of interactions of each agent with all other agents and adds  distractor interactions
    % input:
	% 	pairConnections: matrix specifying the number of interaction of each agent with each other agent
	%     bDistractor: additional distractor interactions are included
	%     numDistractionsPerIndiv:  number of distractor interactions
	% output:
	%		connectionList: matrix of specifying the number of interaction of each agent with each other agent including distractor interactions (marked as "-1")
    
    numIndivs=size(pairConnections,1);
    sumConnections=sum(pairConnections,1);
    sumConnections=sum(sumConnections,2);
    connectionList=zeros(sumConnections, 2);
    assigned=0;
    for ca=1:numIndivs-1
         for cb=ca:numIndivs
              newConns=pairConnections(ca,cb);
              connectionListTemp(assigned+1:assigned+newConns,1)=ca;
              connectionListTemp(assigned+1:assigned+newConns,2)=cb;
              assigned=assigned+newConns;
         end
    end    
    if bDistractor         % if additional distractor interactions are included
        newList=zeros(size(connectionListTemp,1)+numIndivs*numDistractionsPerIndiv,1);
        newList(1:size(connectionListTemp,1),1:2)=connectionListTemp(1:size(connectionListTemp,1),1:2);
        newList(size(connectionListTemp,1)+1:size(connectionListTemp,1)+numIndivs*numDistractionsPerIndiv,1)=-1;        % add -1 into all distractor interaction slots
        for di=1:numIndivs
            newList( size(connectionListTemp,1)+(di-1)*numDistractionsPerIndiv:size(connectionListTemp,1)+di*numDistractionsPerIndiv,2)=di;
        end
        connectionListTemp=newList;
        newOrder=randperm(size(connectionListTemp,1));
        connectionList(1:size(connectionListTemp,1),1:2)=connectionListTemp(newOrder,1:2);
    else                        % if no additional distractor interactions are included
        newOrder=randperm(sumConnections);
        connectionList(1:sumConnections,1:2)=connectionListTemp(newOrder,1:2);
    end
end