%%%%%%%%%%%%%%%%%%%%%%%
% generateNewPopulationRoulette
%%%%%%%%%%%%%%%%%%%%%%%
function [ playerTypes, typeCount, typeOutcome] = generateNewPopulationRoulette( indivOutcomes, playerTypes ,numTypes)
    % Creates on new generation of agents based on the payoff in the current generation
    %   The number of agents playing a strategy in the new generation is chosen. 
	%   The robability of reproductive success is proportional to the total score achieved in a generation.
	%
    % input:
	%		indivOutcomes: total payoff for each agent
	%		playerTypes: contains the strategies (1-9) of all agents
	%		numTypes: number of different strategies still played in the population
    %		
    % output:
	%		playerTypes: strategies that survive to the new genration
	%		typeCount: number of agents playing each strategy in new generation
	%     typeOutcome: average payoff for an agent playing each of the surviving strategies in the last generation
    
	typeCount=zeros(numTypes,1); 
    typeOutcome=zeros(numTypes,1);
    typeCountold=zeros(numTypes,1); 
    numIndivs=size(playerTypes,1);
    totalFitness=sum(indivOutcomes,1);
    relativeFitness=indivOutcomes./totalFitness;
    fitnessSum=zeros(numTypes,1);
    for ci=1:numIndivs
        fitnessSum(playerTypes(ci,1))=fitnessSum(playerTypes(ci,1))+relativeFitness(ci,1);
        typeOutcome(playerTypes(ci,1),1)=typeOutcome(playerTypes(ci,1),1)+indivOutcomes(ci,1);
        typeCountold(playerTypes(ci,1),1)=typeCountold(playerTypes(ci,1),1)+1;
    end
    typeOutcome=typeOutcome./typeCountold;
    for ci=1:numIndivs
        ri=rand(1,1);
        typei=0;
        while ri>= 0
            typei=typei+1;
            ri=ri-fitnessSum(typei,1); 
        end
        playerTypes(ci,1)=typei;
        typeCount(typei,1)=typeCount(typei,1)+1;
    end
end