%%%%%%%%%%%%%%%%%%%%%%%
% createPopulation
%%%%%%%%%%%%%%%%%%%%%%%
function [ playerTypes ] = createPopulation( numIndivs,typeProportions )
% summary: outputs line vector containing the strategy of every single agent
% input:
%   numIndivs: total number of agents
%	typeProportions: proportion of the population playing each strategy
% output:
%	playerTypes: line vector containing the strategy of every agent (in randomized order)
    
    playerTypes=zeros(numIndivs,1);
    b=sum(typeProportions,2);
    b=sum(b,1);
    if round(b)==1
        %values are relative frequencies
        numTypes=size(typeProportions,1);
        currentPos=1;
        for pi= 1: numTypes
            for ci=1:round(typeProportions(pi,1)*numIndivs)
                playerTypes(currentPos,1)=pi;
                currentPos=currentPos+1;
            end
        end
    else
        % values are total frequencies
        numTypes=size(typeProportions,1);
        currentPos=1;
        for pi= 1: numTypes
            for ci=1:typeProportions(pi,1)
                playerTypes(currentPos,1)=pi;
                currentPos=currentPos+1;
            end
        end
    end
    newOrder=randperm(numIndivs);
    playerTypes(1:numIndivs)=playerTypes(newOrder);
end