%%%%%%%%%%%%%%%%%%%%%%%
% createPairConnections
%%%%%%%%%%%%%%%%%%%%%%%
function [ pairConnections ] = createPairConnections( numIndivs, numContacts, pairStrengthSequence )
    %summary: create a pair connection strength matrix
    % will create a matrix of pair connections for
    %	numIndivs Individuals with numContacts contacts: the strength of each
    %	contact in sequence are contained in pairSterengthSequence. The
    %	resulting structure is deterministically created based on a
    %	round-robin tournament
	
     % input:
	% 	numIndivs: total number of agents
	%     numContacts: number of interaction partners
	%     pairStrengthSequence: number of interactions with each partner (high skew, low skew, now skew)
	% output:
	%		pairConnections: matrix containing the number of contacts of each agent with each other agent in one generation
	
    pairConnections=zeros(numIndivs, numIndivs);
    for pairIndex=1:numContacts
        covered=zeros(numIndivs,1);
        pairConnections(min(numIndivs, pairIndex),max(numIndivs, pairIndex))=pairStrengthSequence(pairIndex,1);
        covered(numIndivs)=1;
        covered(pairIndex)=1;
        goalNumber=mod(2*pairIndex, numIndivs-1);
        for testIndiv=1:numIndivs
            if covered(testIndiv,1)==0
                firstNumber=mod(testIndiv, numIndivs-1);
                secondNumber=goalNumber-firstNumber;
                while (secondNumber<1)||(covered(secondNumber,1)~=0)
                    secondNumber=secondNumber+numIndivs-1;
                end
                covered(testIndiv,1)=1;
                covered(secondNumber,1)=1;
                pairConnections(min(testIndiv, secondNumber),max(testIndiv, secondNumber))=pairStrengthSequence(pairIndex,1);
            end
        end
    end 
end