%%%%%%%%%%%%%%%%%%%%%%%
% gameOutcome
%%%%%%%%%%%%%%%%%%%%%%%
function [ actionA,actionB ] = gameOutcome( typeA,typeB,historyA, historyB )
% determines actions of both agents in a single interaction
   
%input:
%	typeA: strategy of agent A
%	typeB: strategy of agent B
%	historyA: past interactions of agent A with agent B
%	historyB: past interactions of agent B with agent A
%output:
%   actionA: action of agent A this round (cooperate(1) or defect(2))
%	actionB: action of agent Bthis round (cooperate(1) or defect(2))
    
    numPastGamesA=size(historyA,1);
    numPastGamesB=size(historyB,1);
    if numPastGamesA==0                         
        historyA=[];
    end
    if numPastGamesB==0
       historyB=[];  
    end
    actionA=reaction(historyA,typeA);         % next action of agent A in dependence of the past interaction history with the same partner and the agent's strategy
    actionB=reaction(historyB,typeB);		   % next action of agent B in dependence of the past interaction history with the same partner and the agent's strategy
end