%%%%%%%%%%%%%%%%%%%%%%%
% gamePayoff
%%%%%%%%%%%%%%%%%%%%%%%
function [ payoff ] = gamePayoff( actionA,actionB )
% summary: outputs the payoff for agent A this round
	
% input:
%	actionA: action of agent A this round (cooperate(1) or defect(2))
%	actionB: action of agent Bthis round (cooperate(1) or defect(2))
% output:
%	payoff: payoff for agent A:
%			A cooperates, B cooperates: 3
%			A cooperates, B defects: 0
%			A defects, B cooperates: 5
%			A defects, B defects: 1
		
    if actionA==1 && actionB==1
        payoff=3;
    elseif actionA==1 && actionB==2
        payoff=0;
    elseif actionA==2 &&  actionB==1
        payoff=5;
    elseif actionB==2 && actionA==2
        payoff=1;
    end  
end