%%%%%%%%%%%%%%%%%%%%%%%
% generateNewPopulationSUS
%%%%%%%%%%%%%%%%%%%%%%%
function [ playerTypes, typeCount, typeOutcome] = generateNewPopulationSUS( indivOutcomes, playerTypes ,numTypes)
    % Creates on new generation of agents based on the payoff in the current generation
    %   The number of agents playing a strategy in the new generation is chosen. 
	%   The robability of reproductive success is proportional to the total score achieved in a generation.
    %
    % input:
	%		indivOutcomes: total payoff for each agent
	%		playerTypes: contains the strategies (1-9) of all agents
	%		numTypes: number of different strategies still played in the population
    %		
    % output:
	%		playerTypes: strategies that survive to the new genration
	%		typeCount: number of agents playing each strategy in new generation
	%     typeOutcome: average payoff for an agent playing each of the surviving strategies in the last generation

    typeCount=zeros(numTypes,1); 						%number of agents playing each strategy
    typeOutcome=zeros(numTypes,1);
    typeCountold=zeros(numTypes,1); 
    numIndivs=size(playerTypes,1);							%total number of agents
    totalFitness=sum(indivOutcomes,1);					%total fitness: sum of all agent's scores
    relativeFitness=indivOutcomes./totalFitness;		%proportional fitness: proportion of individual scores of total fitness
    fitnessSum=zeros(numIndivs,1);
    fitnessSum(1,1)=relativeFitness(1,1);   
    typeOutcome(playerTypes(1,1),1)=typeOutcome(playerTypes(1,1),1)+indivOutcomes(1,1);
    typeCountold(playerTypes(1,1),1)=typeCountold(playerTypes(1,1),1)+1;
    for ci=2:numIndivs
        fitnessSum(ci,1)=fitnessSum(ci-1,1)+relativeFitness(ci,1);
        typeOutcome(playerTypes(ci,1),1)=typeOutcome(playerTypes(ci,1),1)+indivOutcomes(ci,1);
        typeCountold(playerTypes(ci,1),1)=typeCountold(playerTypes(ci,1),1)+1;
    end
    typeOutcome=typeOutcome./typeCountold;
    constantDistance=1/numIndivs;
    searchValue=rand(1,1)*constantDistance;
    searchI=1;
    for ci=1:numIndivs
        while(fitnessSum(searchI)<searchValue)
            searchI=searchI+1;
        end
        searchValue=searchValue+constantDistance;
        playerTypes(ci,1)=playerTypes(searchI);
        typeCount(playerTypes(ci,1),1)=typeCount(playerTypes(ci,1),1)+1;
    end
end