%%%%%%%%%%%%%%%%%%%%%%%
% generateNewPopulationTruncation
%%%%%%%%%%%%%%%%%%%%%%%
function [ playerTypes, typeCount, typeOutcome] = generateNewPopulationTruncation( indivOutcomes, playerTypes ,numTypes, numChosen, deterministic)
    %   The number of agents playing a strategy in the new generation is chosen. 
	%   number of agents that can reproduce is truncated to the top (numChosen) agents  
	%   	If deterministic=0: reproduce equally  
   	%   	If deterministic=1: reproduce with uniform probability 1/p
	
    %input:
	%		indivOutcomes: total payoff for each agent
	%		playerTypes: contains the strategies (1-9) of all agents
	%		numTypes: number of different strategies still played in the population
    %		numChosen: number of Individuals from the Top that can reproduce 
    %  	deterministic: whether they reproduce evenly (not randomly chosen) or with uniform probabilities (1/p)
    %output:
	%		playerTypes: strategies that survive to the new genration
	%		typeCount: number of agents playing each strategy in new generation
	%     typeOutcome: average payoff for an agent playing each of the surviving strategies in the last generation
	
    typeCount=zeros(numTypes,1); 				%number of agents playing each strategy
    typeOutcome=zeros(numTypes,1);						
    typeCountold=zeros(numTypes,1); 						
    numIndivs=size(playerTypes,1);							%total number of agents
    totalFitness=sum(indivOutcomes,1);					%total fitness: sum of all agent's scores
    relativeFitness=indivOutcomes./totalFitness;	%proportional fitness: proportion of individual scores of total fitness
    fitnessSum=zeros(numTypes,1);
    for ci=1:numIndivs													
        fitnessSum(playerTypes(ci,1))=fitnessSum(playerTypes(ci,1))+relativeFitness(ci,1);
        typeOutcome(playerTypes(ci,1),1)=typeOutcome(playerTypes(ci,1),1)+indivOutcomes(ci,1);
        typeCountold(playerTypes(ci,1),1)=typeCountold(playerTypes(ci,1),1)+1; 
    end
    typeOutcome=typeOutcome./typeCountold;
    [sortOutcomes,IndexOutcomes]=sort(indivOutcomes,1);
    relevantIndivs(1:numChosen)=IndexOutcomes(numIndivs-numChosen+1:numIndivs,1);
    relevantTypes(1:numChosen)=playerTypes(relevantIndivs);
    if (deterministic==1)     
        fractionEven=floor(numIndivs/numChosen);
        fractionRemainder=numIndivs-fractionEven*numChosen;
        for ci=1:numChosen
            playerTypes((ci-1)*fractionEven+1:ci*fractionEven,1)=relevantTypes(1,ci);
            typeCount(relevantTypes(1,ci),1)=typeCount(relevantTypes(1,ci),1)+fractionEven;
        end
        if fractionRemainder>0
            playerTypes(numIndivs-fractionRemainder+1:numIndivs,1)...
              = relevantTypes(1,numChosen-fractionRemainder+1: numChosen);
            typeCount( relevantTypes(1,numChosen-fractionRemainder+1: numChosen),1)...
              = typeCount( relevantTypes(1,numChosen-fractionRemainder+1: numChosen),1)+1;
        end
    else      
        for ci=1:numIndivs 
            ri=randi(numChosen);
            playerTypes(ci,1)=relevantTypes(1,ri);
            typeCount( playerTypes(ci,1),1)=typeCount( playerTypes(ci,1),1)+1;
        end
    end
end