%%%%%%%%%%%%%%%%%%%%%%%
% memoryTransform 
%%%%%%%%%%%%%%%%%%%%%%%
function [ newHistoryA, newHistoryB ] = memoryTransform(currentTimeA, currentTimeB, oldHistory,memoryParam1,memoryParam2 ,memoryType,imperfectOwnActionsRandom)
    % creates new Past Interaction Memories for both agents in an interaction
    % applies errors of omission (past interactions forgotten: recall of previous  memory instance) and/or errors of commission (Past interactions misremembered) (set by the 'MemoryType' handle)
    % input:
	%		currentTimeA: current total interaction number of agent A in this generation
	%		currentTimeB: current total interaction number of agent B in this generation
	%		oldHistory: past interaction history between agent A and agent B
	%		memoryParam1: lambda in  forgetting function
	%		memoryParam2: psi in forgetting function (decay rate)
	%		memoryType: Types of memory errors the agents commit
	%				 MemoryType='Random' : Errors of commission (Past interactions misremembered)
    % 			 MemoryType='Forget' : Errors of omission (past interactions forgotten: recall of previous  memory instance)
	%		imperfectOwnActionsRandom: agent imperfectly remembers own actions as well (if =1)
	% output:
	% 	newHistoryA: updated interaction history of agent A
	%		newHistoryB: updated interaction history of agent B
    lambda=memoryParam1;
    psi=memoryParam2;
    numInteractions= size(oldHistory,1);
    if numInteractions>0
        % empirical error rate
        % power function: p=1-92(1+n) ^-0.08 (p error: n: number of intervening
        % interractions
        RememberA(1:numInteractions,1)=lambda.*((currentTimeA-oldHistory(1:numInteractions,3)).^(-psi));      %rembered interaction history of agent A with agent B in agent A's "mind": forgetting function applied to interaction history
        RememberA=(rand(numInteractions,1)-RememberA(1:numInteractions,1))<0;												   %all remembered instances of agent A's interaction history with agent B marked								   
        RememberB(1:numInteractions,1)=lambda.*((currentTimeB-oldHistory(1:numInteractions,4)).^(-psi));		%rembered interaction history of agent B with agent A in agent B's "mind": forgetting function applied to interaction history
        RememberB=(rand(numInteractions,1)-RememberB(1:numInteractions,1))<0;													%all remembered instances of agent B's interaction history with agent A marked		
        if strcmp(memoryType,'Forget')											%Errors of omission (past interactions forgotten: recall of previous  memory instance)
            rmA= find( RememberA(:,1)>0);
            rmB= find( RememberB(:,1)>0);
            a=[1 2 3];
            b=[2 1 4];
            newHistoryA=oldHistory(rmA,a);
            newHistoryB=oldHistory(rmB,b);
        elseif strcmp(memoryType,'Random')										% Errors of commission (Past interactions misremembered)
            randomA=random('bino',1,0.5,numInteractions,1);
            randomB=random('bino',1,0.5,numInteractions,1);
            ForgA= (1-( RememberA(:,1)>0)).*randomA;
            ForgB= (1- ( RememberB(:,1)>0)).*randomB;
            if imperfectOwnActionsRandom								% agent imperfectly remembers own actions as well
                randomA1=random('bino',1,0.5,numInteractions,1);
                randomB1=random('bino',1,0.5,numInteractions,1); 
                ForgA1= (1-( RememberA(:,1)>0)).*randomA1;
                ForgB1= (1- ( RememberB(:,1)>0)).*randomB1;
            end
            a=[1 2 3];
            b=[2 1 4];
            newHistoryA=oldHistory(:,a);
            newHistoryB=oldHistory(:,b);
            newHistoryA(1:numInteractions,2 )= (newHistoryA(1:numInteractions,2)-1)+ForgA.*(1-2*(newHistoryA(1:numInteractions,2)-1)) +1;
            newHistoryB(1:numInteractions,2)= (newHistoryB(1:numInteractions,2)-1)+ForgB.*(1-2*(newHistoryB(1:numInteractions,2)-1)) +1;
            if imperfectOwnActionsRandom
               newHistoryA(1:numInteractions,1 )= (newHistoryA(1:numInteractions,1)-1)+ForgA1.*(1-2*(newHistoryA(1:numInteractions,1)-1)) +1;
               newHistoryB(1:numInteractions,1)= (newHistoryB(1:numInteractions,1)-1)+ForgB1.*(1-2*(newHistoryB(1:numInteractions,1)-1)) +1;
            end    
        end
    else
        newHistoryA=zeros(0,3);
        newHistoryB=zeros(0,3);
    end
end