%%%%%%%%%%%%%%%%%%%%%%%
% playGames
%%%%%%%%%%%%%%%%%%%%%%%
function [ indivOutcomes, typeMatrix, typeMeanMatrix, typeCountMatrix,cooperationRatio,cooperationRatioStrat ] = playGames( connectionList,playerTypes,memoryParam1,memoryParam2,memoryType ,numStrategies,imperfectOwnActions)
    % Main function that simulates all agent interactions in a generation
    %   
    % input: 
	%		connectionList: interaction number of each agents with each other agent
	%		playerTypes: strategies of all agents
	%		memoryParam1: lambda for memory function
	%		memoryParam2: psi for memory function (decay rate)
	%		memoryType: Types of memory errors the agents commit
	%				 MemoryType='Random' : Errors of commission (Past interactions misremembered)
    % 			 MemoryType='Forget' : Errors of omission (past interactions forgotten: recall of previous  memory instance)
	%		numStrategies: number of strategies
	%		imperfectOwnActionsRandom: agent imperfectly remembers own actions as well (if =1)
	% output:
	%		indivOutcomes: total payoff for each agent
	%		typeMatrix: contains total payoff for matchups of each strategy with each other strategy
	%		typeMeanMatrix: contains average payoff per agent for matchups of each strategy with each other strategy
	%		typeCountMatrix: contains number of agents for matchups of each strategy with each other strategy
	%		cooperationRatio: overall ratio of cooperation within generation
	%		cooperationRatioStrat: ratio of cooperation (C) of each strategy
    numGames=size(connectionList,1);
    numIndivs=size(playerTypes,1);				% number of individuals
    indivOutcomes=zeros(numIndivs,1);
    typeMatrix=zeros(numStrategies);
    typeCountMatrix=zeros(numStrategies);
    outcomeList=zeros(numGames,2);
    playerGames=zeros(numIndivs,numIndivs,30);
    indivRounds=zeros(numIndivs,numIndivs,30);
    interactionCount=zeros(numIndivs,1);
    cooperationCount=0; 
    cooperationRatioStrat=zeros(numStrategies,1);					         % ratio of cooperation decision for each of the strategies played 
    for gameIndex=1:numGames
        playerA=min(connectionList(gameIndex,1),connectionList(gameIndex,2));
        playerB=max(connectionList(gameIndex,1),connectionList(gameIndex,2));
        if playerA<0 %distractorEvent
            interactionCount(playerB,1)=interactionCount(playerB,1) +1; 
        end     
        if playerA>0 % if incomplete gamelist, last numbers are 0,0 for players
            historyLength= playerGames(playerA,playerB,1);
            history=zeros(historyLength,4);
            interactionCount(playerA,1)=interactionCount(playerA,1) +1;
            interactionCount(playerB,1)=interactionCount(playerB,1) +1;
            history(1:historyLength,1:2)=outcomeList(playerGames(playerA,playerB,2:historyLength+1),1:2);
            history(1:historyLength,3)=indivRounds(playerA,playerB,1:historyLength); 
            history(1:historyLength,4)=indivRounds(playerB,playerA,1:historyLength); 
            if memoryParam1>-1          % if lambda for memory function > -1: apply memory function
                [historyA,historyB]=memoryTransform(interactionCount(playerA,1),interactionCount(playerB,1),history,memoryParam1,memoryParam2,memoryType,imperfectOwnActions);  
            else
                a=[1 2 3];
                b=[2 1 4];
                historyA=history(a);
                historyB=history(b);
            end
        [actionA,actionB]=gameOutcome(playerTypes(playerA,1),playerTypes(playerB,1),historyA, historyB);                    % determines actions of both agents in a single interaction
        outcomeList(gameIndex,1)=actionA;
        outcomeList(gameIndex,2)=actionB;
        if (actionA==1)
            cooperationCount=cooperationCount+1;
            cooperationRatioStrat(playerTypes(playerA,1),1)=cooperationRatioStrat(playerTypes(playerA,1),1)+1;
        end
        if (actionB==1)
            cooperationCount=cooperationCount+1;
            cooperationRatioStrat(playerTypes(playerB,1),1)=cooperationRatioStrat(playerTypes(playerB,1),1)+1;
        end
        playerGames(playerA,playerB,1)=playerGames(playerA,playerB,1)+1;
        playerGames(playerA,playerB,playerGames(playerA,playerB,1)+1)=gameIndex;
        indivRounds(playerA,playerB,playerGames(playerA,playerB,1))= interactionCount(playerA,1);
        indivRounds(playerB,playerA,playerGames(playerA,playerB,1))= interactionCount(playerB,1);
        payoffA=gamePayoff(actionA,actionB);
        payoffB=gamePayoff(actionB,actionA);
        indivOutcomes(playerA)=indivOutcomes(playerA)+payoffA ;
        indivOutcomes(playerB)=indivOutcomes(playerB)+ payoffB;
        typeCountMatrix(playerTypes(playerA,1),playerTypes(playerB,1))=typeCountMatrix(playerTypes(playerA,1),playerTypes(playerB,1))+1;
        typeCountMatrix(playerTypes(playerB,1),playerTypes(playerA,1))=typeCountMatrix(playerTypes(playerB,1),playerTypes(playerA,1))+1;
        typeMatrix(playerTypes(playerA,1),playerTypes(playerB,1))= typeMatrix(playerTypes(playerA,1),playerTypes(playerB,1))+payoffA;
        typeMatrix(playerTypes(playerB,1),playerTypes(playerA,1))= typeMatrix(playerTypes(playerB,1),playerTypes(playerA,1))+payoffB;
        end      
    end
    typeMeanMatrix=typeMatrix./typeCountMatrix;
    cooperationRatio=cooperationCount/(2*numGames);
    countInteractions=sum(typeCountMatrix,2);
    cooperationRatioStrat=cooperationRatioStrat./countInteractions;
end

