%%%%%%%%%%%%%%%%%%%%%%%
% Agent's next reaction
%%%%%%%%%%%%%%%%%%%%%%%
function [ action ] = reaction( history,pType )
    % determines the next action of an agent in dependence of 
		% a) the past interaction history with the same partner
		% b) the agent's strategy
    %   input:
	%	         history: past interaction history with interaction partner
	%			 ptype: strategy of the agent
	%   output 
	%          action: agent's next action 
	%					1: cooperation 
	%					2: defection

    
    % enter memory-updater
    switch pType
        case 1 %Always Cooperate ALLC
            action=1;
        case 2 % Always Defect ALLD
            action=2;
        case 3 %TIT-for-TAT TFT
            numPreviousGames=size(history,1);    
            if numPreviousGames==0						%if first interaction with specific partner: cooperate
                action=1;
            else
                action=history(numPreviousGames,2);	%else copy partner's previous move
            end
        case 4 %Tit-For-Two-Tat TF2T
                numPreviousGames=size(history,1);
            if numPreviousGames<2						%if first or second interaction with specific partner: cooperate
                action=1;
            else
               if ( history(numPreviousGames,2)==1) || (history(numPreviousGames-1,2)==1)
                   action=1;											%if partner cooperated in any of the last two interactions: cooperate
               else
                   action=2;											%if partner defected in the last two interactions: defect
               end
            end
        case 5 %Generous Tit-For-Tat GTFT 
            numPreviousGames=size(history,1);	
            if numPreviousGames==0						%if first interaction with specific partner: cooperate
                action=1;
            else
                randR=rand(1,1);									
                if history(numPreviousGames,2)==1     %if partner cooperated last round: cooperate with 99% probability, defect with 0% probability
                    if randR<.99
                        action=1;
                    else
                        action=2;
                    end                    
                elseif randR<.33										%if partner defected last round: cooperate with 33% probability, defect with 66% probability									
                    action=1;
                else
                    action=2;
                end              
            end
        case 6 %Win-Stay-Lose-Shift (Pavlov) WSLS
            numPreviousGames=size(history,1);
            if numPreviousGames==0						%if first interaction with specific partner: cooperate
                action=1;
            elseif (history(numPreviousGames,1)==history(numPreviousGames,2))       %if the agent and the partner both cooperated or both defected last round: cooperate
                action=1;
            else																															%if the agent and the partner acted different from each other last round: cooperate
                action=2;						
            end
        case 7      %Random       RAND: cooperate with 50% probability, defect with  50% probability
 
            randR=rand(1,1);
            if randR<.50											
                    action=1;
            else
                    action=2;
            end     
        case 8 %Contrite Tit-For-Tat CTFT
            % cooperate-> cooperate, defect -> only cooperate
            % if you defected two rounds ago and partner did not
            numPreviousGames=size(history,1);
            if numPreviousGames==0							%if first interaction with specific partner: cooperate
                action=1;
            elseif (numPreviousGames>2)&&((history(numPreviousGames-1,2)==1)&&(history(numPreviousGames-1,1)==2))    %if two rounds prior both the partner cooperated and the agent defected: cooperate
                action=1;
            elseif (history(numPreviousGames,2)==1)								%if partner cooperated previous round: cooperate
                action=1;
            else																								%if partner defected last round and two rounds prior (the agent cooperated or the partner defected): defect
                action=2;
            end 
        case 9 %Grim Trigger GRIM
            % http://en.wikipedia.org/wiki/Grim_trigger
            numPreviousGames=size(history,1);
            if numPreviousGames==0							%if first interaction with specific partner: cooperate
                action=1;
            elseif (history(numPreviousGames,1)==2)||(history(numPreviousGames,2)==2)      %if partner defected last round or agent defected last round: defect
                action=2;
            else								%if agent and partner cooperated last round: cooperate
                action=1;
            end  
    end 
end